﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.IO.Ports;                  // NuGetでSystem.IO.Portsの追加が必要
using System.Management;                // NuGetでSystem.Managementの追加が必要
using System.Text.RegularExpressions;   // 文字列操作定義

namespace NEW_GDM
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private int Opened;
        private static SerialPort serialPort = new SerialPort();

        public MainWindow()
        {
            InitializeComponent();
            Opened = 0;
            btnOpen_Close.Content = "OPEN";
            btnRead.IsEnabled = false;
            btnSend.IsEnabled = false;

            cmbBaud.Items.Add("9600");
            cmbBaud.Items.Add("19200");
            cmbBaud.Items.Add("38400");
            cmbBaud.Items.Add("57600");
            cmbBaud.Items.Add("115200");
            cmbBaud.SelectedIndex = 0;
            refresh_com();
            cmbSendMsg.Items.Add("*idn?");
            cmbSendMsg.Items.Add("*cls?");
            cmbSendMsg.Items.Add("syst:err?");
            cmbSendMsg.Items.Add("syst:loc");

        }

        private void btnOpen_Close_click(object sender, RoutedEventArgs e)
        {
            if (Opened == 0)
            {

                //Port number assgin
                var matche = new Regex(@"\((.+?)\)").Matches(cmbAddress.Text);
                string portAddress = matche[0].Value.Trim('(', ')');

                try
                {
                    // Device Open and Init
                    serialPort.PortName = portAddress;
                    serialPort.BaudRate = Int32.Parse(cmbBaud.Text);
                    serialPort.DataBits = 8;
                    serialPort.StopBits = System.IO.Ports.StopBits.One;
                    serialPort.Parity = System.IO.Ports.Parity.None;
                    serialPort.Handshake = System.IO.Ports.Handshake.None;
                    serialPort.ReadTimeout = 1000;
                    serialPort.WriteTimeout = 1000;
                    serialPort.Encoding = Encoding.UTF8;

                    serialPort.Open();
                    serialPort.DiscardInBuffer();
                    serialPort.WriteLine("*cls");

                    btnOpen_Close.Content = "CLOSE";
                    btnRead.IsEnabled = true;
                    btnSend.IsEnabled = true;
                    btnRefresh.IsEnabled = false;
                    cmbAddress.IsEnabled = false;
                    cmbBaud.IsEnabled = false;

                    Opened = 1;
                    serialPort.WriteLine("*idn?");
                    System.Threading.Thread.Sleep(200);
                    btn_Read();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                    Opened = 0;
                }
                finally
                {
                    ;
                }
            }
            else
            {
                serialPort.WriteLine("syst:loc");
                btnOpen_Close.Content = "OPEN";
                btnRead.IsEnabled = false;
                btnSend.IsEnabled = false;
                btnRefresh.IsEnabled = true;
                cmbAddress.IsEnabled = true;
                cmbBaud.IsEnabled = true;
                txtReadMsg.Text = "";
                serialPort.Close();
                Opened = 0;
            }
        }

        private void btnRefresh_Click(object sender, RoutedEventArgs e)
        {
            refresh_com();
        }


        private void btnSend_Click(object sender, RoutedEventArgs e)
        {
            string SendMsg;

            SendMsg = cmbSendMsg.Text;
            try
            {
                WriteLine(SendMsg + "\n");
                if (cmbSendMsg.SelectedIndex == -1)
                {
                    cmbSendMsg.Items.Add(SendMsg);
                }
                if (SendMsg.IndexOf("?") >= 0)
                {
                    System.Threading.Thread.Sleep(200);
                    btn_Read();
                }

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnRead_Click(object sender, RoutedEventArgs e)
        {
            btn_Read();
        }

        private void FormClosing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            // Device Close
            if (Opened != 0)
            {
                if (serialPort.IsOpen)
                {
                    serialPort.Close();
                }
                serialPort = null;
            }
        }

        private void btn_Read()
        {
            try
            {
                txtReadMsg.Text = Readbuff() + "\r\n";
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                ;
            }
        }


        private void WriteLine(string sendMsg)
        {
            serialPort.WriteLine(sendMsg);
        }

        private string Readbuff()
        {
            return serialPort.ReadExisting();
        }
        // Rescan comport
        private void refresh_com()
        {
            cmbAddress.Items.Clear();
            cmbAddress.Text = "";

            //Port description  FTDI:OK 
            var CheckComNum = new System.Text.RegularExpressions.Regex("COM[1-9][0-9]?[0-9]?");
            System.Management.ManagementClass mcPnPEntity = new System.Management.ManagementClass("Win32_PnPEntity");
            System.Management.ManagementObjectCollection manageObjCol = mcPnPEntity.GetInstances();
            foreach (System.Management.ManagementObject manageObj in manageObjCol)
            {
                var namePropertyValue = manageObj.GetPropertyValue("Name");

                if (namePropertyValue == null) continue;
                string name = namePropertyValue.ToString();
                if (CheckComNum.IsMatch(name)) cmbAddress.Items.Add(name);
            }
            if (cmbAddress.Items.Count > 0) cmbAddress.SelectedIndex = 0;
        }


    }
}