﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using Ivi.Visa.Interop;


namespace TEXIO_VISA_TEST
{
    public partial class Form1 : Form
    {
        private const string IF_TMC =   "USB-TMC";
        private const string IF_RSCDC = "RS-232C/USB-CDC";
        private const string IF_LAN =   "LAN Socket";
        private const string IF_GPIB =  "GP-IB";
        private const string IF_LXI =   "LXI";

        private IUsb usb;
        private ISerial seri;
        private ITcpipSocket tcpsoket;
        private IGpib gpib;
        private ITcpipInstr tcplxi;

        private IResourceManager VISA_RM = new Ivi.Visa.Interop.ResourceManager();
        private IMessage  VISA_CMB ;

        public Form1()
        {
            InitializeComponent();

            //数字・時刻表記を米国式に固定、日本では通常は不要
            System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.InvariantCulture;

            cmbIFType.Items.Add(IF_TMC);
            cmbIFType.Items.Add(IF_RSCDC);
            cmbIFType.Items.Add(IF_LAN);
            cmbIFType.Items.Add(IF_GPIB); 
            cmbIFType.Items.Add(IF_LXI);

            cmbIFType.SelectedIndex = 0;
            txtSendMessage.Text = "*IDN?";
            lblReceiveMessage.Text = String.Empty;
            btnOpenClose.Text = "OPEN";
            btnOpenClose.Enabled = false;
            btnFindRc.Enabled = true;
            cmbIFType.Enabled = true;
            cmbDeviceList.Enabled = true;
            txtComProperty.Enabled = true;
            btnReceive.Enabled = false;
            btnSend.Enabled = false;
        }

        private void cmbIFType_SelectedIndexChanged(object sender, EventArgs e)
        {
            cmbDeviceList.Items.Clear();
            btnOpenClose.Enabled = false;
            cmbDeviceList.Text = "";

            switch (cmbIFType.Text)
            {
                case IF_TMC:
                    txtComProperty.Visible = false;
                    lblComPropertyTitle.Visible = false;
                    txtComProperty.Text = "9600";
                    break;

                case IF_RSCDC:
                    txtComProperty.Visible = true;
                    lblComPropertyTitle.Visible = true;
                    lblComPropertyTitle.Text = "RS-232C Baudrate";
                    txtComProperty.Text = "9600";
                    break;

                case IF_LAN:
                    txtComProperty.Visible = true;
                    lblComPropertyTitle.Visible = true;
                    lblComPropertyTitle.Text = "TCPIP ADDR::PORT";
                    txtComProperty.Text = "192.168.1.1::5025";
                    btnOpenClose.Enabled = true;
                    break;

                case IF_GPIB:
                    txtComProperty.Visible = false;
                    lblComPropertyTitle.Visible = false;
                    lblComPropertyTitle.Text = "GP-IB Address";
                    txtComProperty.Text = "";
                    break;

                case IF_LXI:
                    txtComProperty.Visible = true;
                    lblComPropertyTitle.Visible = true;
                    lblComPropertyTitle.Text = "TCPIP ADDR";
                    txtComProperty.Text = "";
                    break;
           
                default:
                    break;
            }
        }
        private void btnFindRc_Click(object sender, EventArgs e)
        {// FindResourceはNI-MAXに登録されているリソースを検索します。未登録は表示されません。
            try
            {
                string[] VISAResources= null;
                System.Windows.Forms.Cursor.Current = Cursors.WaitCursor;
                switch (cmbIFType.Text)
                {
                    case IF_GPIB :
                        VISAResources = VISA_RM.FindRsrc("GPIB?*INSTR");
                        break;

                    case IF_TMC :
                        VISAResources = VISA_RM.FindRsrc("USB?*INSTR");
                        break;

                    case IF_RSCDC :
                        VISAResources = VISA_RM.FindRsrc("ASRL?*");
                        break;

                    case IF_LAN:
                        VISAResources = VISA_RM.FindRsrc("TCPIP0::" + txtComProperty.Text.Trim() + "::Socket");
                        break;

                    case IF_LXI:
                        VISAResources = VISA_RM.FindRsrc("TCPIP0::" + txtComProperty.Text.Trim() + "::inst0::INSTR");
                        break;
                }

                cmbDeviceList.Items.Clear();
                cmbDeviceList.Text = "";
                foreach (string s in VISAResources)
                {
                    cmbDeviceList.Items.Add(s);
                }

                if (cmbDeviceList.Items.Count > 0)
                {
                    cmbDeviceList.SelectedIndex = 0;
                    btnOpenClose.Enabled = true;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("VISA Device is not found!!" , "ERROR" , MessageBoxButtons.OK );
            }
            finally
            {
                System.Windows.Forms.Cursor.Current = Cursors.Default;
            }
        }

        private void btnOpenClose_Click(object sender, EventArgs e)
        {
            try
            { 
                System.Windows.Forms.Cursor.Current = Cursors.WaitCursor;
                if (btnOpenClose.Text == "OPEN")
                {
                    btnOpenClose.Text = "CLOSE";
                    btnFindRc.Enabled = false;
                    cmbIFType.Enabled = false;
                    cmbDeviceList.Enabled = false;

                    VISA_CMB = (IMessage)VISA_RM.Open(cmbDeviceList.Text.Trim(), AccessMode.NO_LOCK, 0, "");
                    VISA_CMB.Timeout = 1000;
                    VISA_CMB.TerminationCharacter = 10;
                    VISA_CMB.TerminationCharacterEnabled = false;
                    VISA_CMB.SendEndEnabled = true;
                    txtComProperty.Enabled = false;
                    btnReceive.Enabled = true;
                    btnSend.Enabled = true;

                    switch (cmbIFType.Text)
                    {
                        case IF_TMC:                // USB-TMC
                            usb = (IUsb)VISA_CMB;
                            break;

                        case IF_RSCDC:
                            seri = (ISerial)VISA_CMB;
                            seri.BaudRate = int.Parse(txtComProperty.Text);     //文字列を整数へ変換
                            seri.DataBits = 8;
                            seri.StopBits = SerialStopBits.ASRL_STOP_ONE;
                            seri.Parity = SerialParity.ASRL_PAR_NONE;
                            seri.FlowControl = SerialFlowControl.ASRL_FLOW_NONE;
                            break;

                        case IF_LAN:
                            tcpsoket = (ITcpipSocket)VISA_CMB;
                            break;

                        case IF_GPIB:
                            gpib = (IGpib)VISA_CMB;
                            break;

                        case IF_LXI:
                            tcplxi = (ITcpipInstr)VISA_CMB;
                            break;

                        default:
                            break;
                    }
                    VISA_CMB.TerminationCharacterEnabled = true;
                }
                else
                {
                    btnOpenClose.Text = "OPEN";
                    btnFindRc.Enabled = true;
                    cmbIFType.Enabled = true;
                    cmbDeviceList.Enabled = true;
                    txtComProperty.Enabled = true;
                    btnReceive.Enabled = false;
                    btnSend.Enabled = false;
                    lblReceiveMessage.Text = "";
                    VISA_CMB.Close();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("VISA OPEN ERROR!!", "ERROR", MessageBoxButtons.OK);
            }
            finally
            {
                System.Windows.Forms.Cursor.Current = Cursors.Default;
            }
        }

        private void btnSend_Click(object sender, EventArgs e)
        {
            try
            {
                string textToWrite = ReplaceCommonEscapeSequences(txtSendMessage.Text) +"\n";
                VISA_CMB.WriteString(textToWrite);

                if (textToWrite.IndexOf("?") >= 0)          //文字列に？が含まれている場合
                {
                    System.Threading.Thread.Sleep(200);
                    string responseString = VISA_CMB.ReadString(256);
                    lblReceiveMessage.Text = InsertCommonEscapeSequences(responseString);
                }
            }
            catch (Exception exp)
            {
                MessageBox.Show(exp.Message);
            }
        }

        private void btnReceive_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            try
            {
                string responseString = VISA_CMB.ReadString(256);
                lblReceiveMessage.Text = InsertCommonEscapeSequences(responseString);
            }
            catch (Exception exp)
            {
                MessageBox.Show(exp.Message);
            }
            finally
            {
                Cursor.Current = Cursors.Default;
            }
        }

        //フォームの右上のｘボタンの処理  VISA_CMB使用中はクローズ、破棄
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (VISA_CMB != null)
            {
                try
                {
                    VISA_CMB.Close();
                    VISA_CMB = null;
                }
                catch (Exception exp)
                {
                    ;
                }
            }
        }

        private string ReplaceCommonEscapeSequences(string s)       //\を\\に変換
        {
            return s.Replace("\\n", "\n").Replace("\\r", "\r");
        }
        private string InsertCommonEscapeSequences(string s)        //\\を\に変換
        {
            return s.Replace("\n", "\\n").Replace("\r", "\\r");
        }

    }
}
