﻿//   GDM Series Serial Sample Program　for VC# 2008 or Higher
//   Please Open project (.csproj), Not Open Solution
//   ソリューションファイルでなくプロジェクトファイル(.csproj)を開いてください。

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace PSW_Access
{
    public partial class PSW_Access : Form
 
    {
        public int Opened;

        // Open Window
        public PSW_Access()
        {
            InitializeComponent();

            Opened = 0;
            for (int i = 1; i < 30; i++)
                cmbAddress.Items.Add(i);
            cmbAddress.SelectedIndex = 0;

            // Set form
            btnOpen_Close.Text = "OPEN";
            btnAUTO.Enabled = false;
            btnMonitor.Enabled = false;
            btnDCV.Enabled = false;
            btnACV.Enabled = false;
            btnFREQ.Enabled = false;
            cmbAddress.Enabled = true;
        }

        // Form Close(x Button)
        private void Form1_FormClosing(object sender,FormClosingEventArgs e)
        {
            // Device Close
            if (cmbAddress.Enabled == false)
            {
                serialPort1.WriteLine("CONF:AUTO OFF\n");
                System.Threading.Thread.Sleep(200);
            }
            if (Opened != 0)
            {
                serialPort1.Close();
            }
        }
        // Open/Close Button
        private void btnOpen_Close_Click(object sender, EventArgs e)
        {
            if(btnOpen_Close.Text == "OPEN"){
                try
                {
                    Opened = 1;
                    Cursor.Current = Cursors.WaitCursor;
                    // Device Open and Init
                    serialPort1.PortName = "COM" + (cmbAddress.SelectedIndex + 1).ToString();
                    serialPort1.BaudRate = 115200;
                    serialPort1.DataBits = 8;
                    serialPort1.StopBits = System.IO.Ports.StopBits.One;
                    serialPort1.Parity = System.IO.Ports.Parity.None;
                    serialPort1.Handshake = System.IO.Ports.Handshake.None;
                    serialPort1.Open();
                    serialPort1.DiscardInBuffer();

                    serialPort1.WriteLine("*cls\n");
                    serialPort1.WriteLine("CONF:AUTO OFF\n");

                    btnAUTO.Text = "AUTO ON";

                    // Set form
                    btnOpen_Close.Text = "CLOSE";
                    btnAUTO.Enabled = true;
                    btnMonitor.Enabled = true;
                    btnDCV.Enabled = true;
                    btnACV.Enabled = true;
                    btnFREQ.Enabled = true;
                    cmbAddress.Enabled = false;

                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
                finally
                {
                    Cursor.Current = Cursors.Default;
                }
            }
            else{
                try
                {
                    // Device Close
                    serialPort1.WriteLine("CONF:AUTO OFF\n");
                    serialPort1.WriteLine("SYST:LOC\n");
                    System.Threading.Thread.Sleep(200);
                    serialPort1.Close();

                    // Set form
                    btnOpen_Close.Text = "OPEN";
                    btnAUTO.Enabled = false ;
                    btnDCV.Enabled = false;
                    btnACV.Enabled = false;
                    btnFREQ.Enabled = false;
                    btnMonitor.Enabled = false ;

                    cmbAddress.Enabled = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }

        }
        
        // Monitor Button
        private void btnMonitor_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                serialPort1.WriteLine(":READ?\n");
                System.Threading.Thread.Sleep(500);
                txtMeasure.Text = serialPort1.ReadExisting() + " \r\n"; ;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                Cursor.Current = Cursors.Default;
            }
        }


        private void btnAUTO_Click(object sender, EventArgs e)
        {
            if (btnAUTO.Text == "AUTO ON")
            {
                // OFF -> ON
                serialPort1.WriteLine(":CONF:AUTO ON\n");
                btnAUTO.Text = "AUTO OFF";
            }
            else
            {
                // ON -> OFF
                serialPort1.WriteLine(":CONF:AUTO OFF\n");
                btnAUTO.Text = "AUTO ON";
            }
        }
       


        private void btnDCV_Click(object sender, EventArgs e)
        {
            serialPort1.WriteLine(":CONF:VOLT:DC\n");
        }

        private void btnACV_Click(object sender, EventArgs e)
        {
            serialPort1.WriteLine(":CONF:VOLT:AC\n");
        }

        private void btnFREQ_Click(object sender, EventArgs e)
        {
            serialPort1.WriteLine(":CONF:FREQ\n");
        }


        private string ReplaceCommonEscapeSequences(string s)
        {
            return s.Replace("\\n", "\n").Replace("\\r", "\r");
        }

        private string InsertCommonEscapeSequences(string s)
        {
            return s.Replace("\n", "\\n").Replace("\r", "\\r");
        }
    }
}
