﻿'   GDM Series Serial Sample Program　for Vb2008 or Higher
'   Please Open project (.vbproj), Not Open Solution

'   ソリューションファイルでなくプロジェクトファイル(.vbproj)を開いてください。

Imports System
Imports System.Drawing
Imports System.Collections
Imports System.ComponentModel
Imports System.Windows.Forms


Public Class mainForm

    Private Opened As Integer

    ' OPNE/CLOSE
    Private Sub btnOpen_Close_Click(sender As Object, e As EventArgs) Handles btnOpen_Close.Click

        Opened = 1
        If (btnOpen_Close.Text = "OPEN") Then
            Try
                Cursor.Current = Cursors.WaitCursor
                ' Device Open and Init
                SerialPort1.PortName = "COM" + (cmbAddress.SelectedIndex + 1).ToString()
                SerialPort1.BaudRate = 115200
                SerialPort1.DataBits = 8
                SerialPort1.StopBits = System.IO.Ports.StopBits.One
                SerialPort1.Parity = System.IO.Ports.Parity.None
                SerialPort1.Handshake = System.IO.Ports.Handshake.None
                SerialPort1.Open()
                SerialPort1.DiscardInBuffer()
                SerialPort1.WriteLine("CONF:AUTO OFF" + vbLf)

                btnAUTO.Text = "AUTO ON"

                ' Set form
                btnOpen_Close.Text = "CLOSE"
                btnAUTO.Enabled = True
                btnDCV.Enabled = True
                btnACV.Enabled = True
                btnFREQ.Enabled = True
                btnMonitor.Enabled = True


                cmbAddress.Enabled = False

            Catch ex As Exception
                MessageBox.Show(ex.Message)
            Finally
                Cursor.Current = Cursors.Default
            End Try
        Else
            Try
                'Device Close
                SerialPort1.WriteLine("CONF:AUTO OFF" + vbLf)
                SerialPort1.WriteLine("SYST:LOC" + vbLf)
                System.Threading.Thread.Sleep(200)
                SerialPort1.Close()

                'Set form
                btnOpen_Close.Text = "OPEN"
                btnAUTO.Enabled = False
                btnMonitor.Enabled = False
                btnDCV.Enabled = False
                btnACV.Enabled = False
                btnFREQ.Enabled = False
                cmbAddress.Enabled = True

            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End If
    End Sub

    'Form Close(x Button)
    Private Sub mainForm_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        'Device Close
        If (cmbAddress.Enabled = False) Then
            SerialPort1.WriteLine("CONF:AUTO OFF" + vbLf)
            System.Threading.Thread.Sleep(200)
        End If
        If (Opened <> 0) Then
            SerialPort1.Close()
        End If
    End Sub


    'Load ON/OFF
    Private Sub btnLoad_Click(sender As Object, e As EventArgs)
        If (btnAUTO.Text = "AUTO ON") Then
            ' OFF -> ON
            SerialPort1.WriteLine("CONF:AUTO ON" + vbLf)
            btnAUTO.Text = "AUTO OFF"
        Else
            ' ON -> OFF
            SerialPort1.WriteLine("CONF:AUTO OFF" + vbLf)
            btnAUTO.Text = "AUTO ON"
        End If
    End Sub


    ' Monitor
    Private Sub btnMonitor_Click(sender As Object, e As EventArgs) Handles btnMonitor.Click

        Try
            Cursor.Current = Cursors.WaitCursor
            SerialPort1.WriteLine("READ?" + vbLf)
            System.Threading.Thread.Sleep(500)
            txtMeasure.Text = SerialPort1.ReadExisting() + vbCrLf

        Catch ex As Exception
            MessageBox.Show(ex.Message)
        Finally
            Cursor.Current = Cursors.Default
        End Try
    End Sub

    'Load
    Private Sub mainForm_Load(sender As Object, e As EventArgs) Handles Me.Load
        Dim i As Integer
        Opened = 0
        For i = 1 To 29
            cmbAddress.Items.Add(i)
        Next i
        cmbAddress.SelectedIndex = 0

        ' Set form
        btnOpen_Close.Text = "OPEN"
        btnAUTO.Enabled = False
        btnDCV.Enabled = False
        btnACV.Enabled = False
        btnFREQ.Enabled = False
        btnMonitor.Enabled = False

        cmbAddress.Enabled = True
    End Sub

    'AUTO on/off
    Private Sub btnAUTO_Click(sender As System.Object, e As System.EventArgs) Handles btnAUTO.Click
        If (btnAUTO.Text = "AUTO ON") Then
            ' OFF -> ON
            SerialPort1.WriteLine("CONF:AUTO ON" + vbLf)
            btnAUTO.Text = "AUTO OFF"
        Else
            ' ON -> OFF
            SerialPort1.WriteLine("CONF:AUTO OFF" + vbLf)
            btnAUTO.Text = "AUTO ON"
        End If
    End Sub

    Private Sub btnDCV_Click(sender As System.Object, e As System.EventArgs) Handles btnDCV.Click

        SerialPort1.WriteLine("CONF:VOLT:DC" + vbLf)

    End Sub

    Private Sub btnACV_Click(sender As System.Object, e As System.EventArgs) Handles btnACV.Click

        SerialPort1.WriteLine("CONF:VOLT:AC" + vbLf)

    End Sub

    Private Sub btnFREQ_Click(sender As System.Object, e As System.EventArgs) Handles btnFREQ.Click

        SerialPort1.WriteLine("CONF:FREQ" + vbLf)

    End Sub
End Class
